﻿$.fn.uislider = $.fn.slider;
Voxco = { onPageReady: $(document).ready };
window.onunload = function () { }; //added for bfcache

function UpdateRespondentLanguage(languageCode) {
    __doPostBack("LanguageSelector", languageCode);
}

function toggleOpenEnd(input, singleChoice, container) {
    if (container == null) {
        container = input.parents(".choiceList");
    }

    var openEnd = $("#" + input.attr("id") + "_openEnd", container);
    var openEndDiv = openEnd.parent();
    var hasHidden = openEndDiv.hasClass("openEndHidden");
    var isChecked = input.is(":checked");

    if (singleChoice) {
        $(".openEndHidden", container).hide();
        $(".openEnd", container).prop("disabled", true);
    }

    if (openEndDiv.length > 0) {
        if (hasHidden) {
            openEndDiv.toggle(isChecked);
        }

        openEnd.prop("disabled", !isChecked);
    }
}

function isInGrid(element) {
    return $(element).closest("table").hasClass("grid");
}

function hasAnswer(rowOrColumn) {
    // Also check value for dropdown because some options in the dropdown might not have a value
    var hasValue =
        $("input.textAnswer, input.numericAnswer, input.sliderValue, input.starRatingValue, select.dropDownList", rowOrColumn)
            .filter(function () { return $(this).val() !== ""; })
            .length > 0;

    var hasChoice =
        $("input:checkbox:checked, input:radio:checked", rowOrColumn)
            .length > 0;

    return hasValue || hasChoice;
}

function setOpenEndEnabledOrDisabled(openEnds, disabled) {
    openEnds.each(function () {
        if ($(this).css("display") !== "none") {
            $(this).prop("disabled", disabled);
        }
    })
}

function toggleRowOpenEnds(control) {
    var row = $(control).closest("tr.gridAlternateRow, tr.gridRow");
    var hasRowAnswer = hasAnswer(row);
    var openEnds = $("div.openEndBelow, div.openEndRight", row).find("textarea.openEnd");

    // Check the next row in case the open-end is displayed as a row
    if (openEnds.length == 0) {
        var nextRow = $(row).next();
        var hasRowOpenEnds = $(".openEndRow", nextRow).length > 0;
        if (hasRowOpenEnds) {
            openEnds = $("textarea.openEnd", nextRow);
        }
    }

    if (openEnds.length > 0) {
        setOpenEndEnabledOrDisabled(openEnds, !hasRowAnswer);
    }
}

function toggleColumnOpenEnds(control) {
    var table = $(control).closest("table.grid");
    var choiceColumns = $("th[data-choice-position]", table);

    // Loop through every column because a selected choice grid radio will deselect the radios in the other columns
    for (var choicePosition = 0; choicePosition < choiceColumns.length; choicePosition++) {
        var column = $(".gridItem[data-choice-position=" + choicePosition + "]", table);
        var hasColumnAnswer = hasAnswer(column);

        // Handle column open-ends displayed below or on the right
        var headerOpenEnds =
            $("th.gridColumnHeader[data-choice-position=" + choicePosition + "]", table)
                .find("div.openEndBelow, div.openEndRight")
                .find("textarea.openEnd");

        if (headerOpenEnds.length > 0) {
            setOpenEndEnabledOrDisabled(headerOpenEnds, !hasColumnAnswer);
        }

        // Handle open-ends displayed as column
        var columnOpenEnds =
            $("td.gridColumnOpenEnd", table)
                .filter(function () { return $(this).attr("headers").endsWith("_" + choicePosition); })
                .find("textarea.openEnd");

        if (columnOpenEnds.length > 0) {
            setOpenEndEnabledOrDisabled(columnOpenEnds, !hasColumnAnswer);
        }
    }
}

function toggleGridOpenEnds(control) {
    toggleRowOpenEnds(control);
    toggleColumnOpenEnds(control);
}

function IsIE() {
    var undef, v = 3, div = document.createElement('div');

    while (
        div.innerHTML = '<!--[if gt IE ' + (++v) + ']><i></i><![endif]-->',
        div.getElementsByTagName('i')[0]
    );

    //check for IE7
    if (v <= 4 && navigator.appVersion.indexOf("MSIE 10.") != -1)
        v = 10;

    return v > 4 ? v : undef;
}

function ValidateNumberKeyCode(event, allowNegative, value, maxLength) {
    // Allow backspace and delete
    // Ensure that it is a number and stop the keypress (0-9 are ascii code 48 to 57)
    if (!(event.which == 0 // For FireFox
        || event.which == 46 || event.which == 8 || event.which == 45 || event.which == 9      // delete,  backspace, and tab
        || (event.which == 109 && allowNegative)
        || event.which == 37 || event.which == 39         // left and right arrow
        || (event.which >= 48 && event.which <= 57)
        || (event.which >= 96 && event.which <= 105))     // numberpad 0 to 9
        || ((value && maxLength)
            && (((48 <= event.which && event.which <= 57) || (96 <= event.which && event.which <= 105))
                && (value.length + 1) > maxLength))) {
        event.preventDefault();
        return false;
    }

    return true;
}

function hasFocus(classes) {
    return classes.some(function (token) {
        var activeElement = document.activeElement;
        if (activeElement) {
            return activeElement.classList.contains(token);
        }
        return false;
    });
}

function ArrowKeyNavigation(e, activeElement) {
    var radioBtns = $("input[name=" + activeElement.name + "]");
    var index = radioBtns.index(activeElement);

    if (e.key == "ArrowRight" || e.key == "ArrowDown") {
        index = index + 1;
    } else {
        index = index - 1;
    }

    radioBtns.each(function () { $(this).attr("tabindex", "-1"); });
    $(radioBtns[index]).attr("tabindex", "0");
}

$(document).ready(function () {

    //This document.ready will run after all others.
    $(document).ready(function () {
        if ($("#MainPageDiv").hasClass("hideTooltips"))
            $("*[title]").removeAttr("title");

        $(".questionBackground").css("visibility", "visible");

        var firstErrorMessage = _.first($(".errorMessageContainer").not(".pageErrors"));
        if (firstErrorMessage) {
            firstErrorMessage.focus();
        }
    });

    // Set browser date metadata.
    var now = new Date();
    $("#BrowserTimeZoneOffset").val(-now.getTimezoneOffset()); // Gets the browser's current timezone offset from UTC in minutes.

    $(document).on("keydown", function (e) {
        var activeElement = document.activeElement;
        var arrowKeys = ["ArrowLeft", "ArrowRight", "ArrowUp", "ArrowDown"];

        if (activeElement.type === "radio" && arrowKeys.indexOf(e.key) > -1) {
            ArrowKeyNavigation(e, activeElement);
        }

        if (e.key == "Enter") {
            if (hasFocus(["backButton", "quitButton"])) {
                e.preventDefault();
                activeElement.click();
            } else if (hasFocus(["languageSelectorDropdown"])) {
                e.preventDefault();
                UpdateRespondentLanguage(activeElement.value);
            }
        }
    });

    $(".languageSelectorDropdown").on('input', function () {
        UpdateRespondentLanguage(this.value);
    });
});